/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import adql.db.DBChecker;
import adql.db.DefaultDBTable;
import adql.db.exception.UnresolvedIdentifiersException;
import adql.parser.ADQLParser;
import adql.parser.ParseException;
import adql.query.ADQLQuery;
import adql.query.from.ADQLTable;
import cds.aladin.Aladin;
import cds.aladin.Constants;
import cds.aladin.FilterActionClass;
import cds.aladin.FilterDocument;
import cds.aladin.FrameInfoServer;
import cds.aladin.GrabItFrame;
import cds.aladin.JoinFacade;
import cds.aladin.Server;
import cds.aladin.ServerObsTap;
import cds.aladin.ServerTap;
import cds.aladin.ServerTapExamples;
import cds.aladin.TapClient;
import cds.aladin.TapManager;
import cds.aladin.TapTable;
import cds.aladin.TapTableColumn;
import cds.aladin.UWSFacade;
import cds.tools.CDSConstants;
import cds.tools.ConfigurationReader;
import cds.tools.Util;
import cds.xml.VOSICapabilitiesReader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public abstract class DynamicTapForm
extends Server
implements FilterActionClass {
    private static final long serialVersionUID = 8296179835574266057L;
    private static final int TAPSCHEMACOUNT = 5;
    public static String TIPRETRY = Aladin.chaine.getString("TAPTIPRETRY");
    public static String TAPTABLEUPLOADTIP = Aladin.chaine.getString("TAPTABLEUPLOADTIP");
    public static String TAPTABLENOUPLOADTIP = Aladin.chaine.getString("TAPTABLENOUPLOADTIP");
    public static String REFRESHQUERYTOOLTIP = Aladin.chaine.getString("REFRESHQUERYTOOLTIP");
    public static String CHECKQUERYTOOLTIP = Aladin.chaine.getString("CHECKQUERYTOOLTIP");
    public static String SYNCASYNCTOOLTIP = Aladin.chaine.getString("SYNCASYNCTOOLTIP");
    public static String SHOWASYNCTOOLTIP = Aladin.chaine.getString("SHOWASYNCTOOLTIP");
    public static String TAPTABLEJOINTIP;
    public static String DISCARD;
    public static String DISCARDTIP;
    public static String SETRADECBUTTONTIP;
    public static String CHANGETARGETSETTINGSTOOLTIP;
    public static String TIPCLICKTOADD;
    public static String TAPEXDEFAULTMAXROWS;
    public static String NORANGEERRORMESSAGE;
    public static String TAPERRORSTATUSINFO;
    public static String TAPLOADINGSTATUSINFO;
    public static String MESSAGEUNKNOWNPARAMSINQUERY;
    public static String TAPTABLEUPLOADLIMITTOOLTIP;
    public static String NOSTACKTABLES;
    public String CLIENTINSTR;
    String selectedTableName;
    String loadedServerDescription;
    public boolean isFullServer = true;
    protected int formLoadStatus = 0;
    protected JLabel info1;
    JComboBox tablesGui;
    protected JComboBox<String> sync_async;
    protected JComboBox<String> circleOrSquare;

    public DynamicTapForm() {
        this.type = 2;
        this.aladinLabel = "TAP";
        this.aladinLogo = "TAP.png";
        this.adqlParser = new ADQLParser();
        this.info1 = new JLabel();
    }

    public DynamicTapForm(Aladin aladin) {
        this();
        this.aladin = aladin;
        this.createChaine();
    }

    abstract void createFormDefault();

    public void setBasics() {
        this.type = 2;
        this.verboseDescr = this.loadedServerDescription;
        this.setLayout(new BorderLayout());
        this.setOpaque(true);
        this.setBackground(this.tapClient.primaryColor);
        this.setFont(Aladin.PLAIN);
    }

    public void setTopPanel(JPanel containerPanel, GridBagConstraints c, JLabel info1, String clientInstrucMessage) {
        containerPanel.setBackground(this.tapClient.primaryColor);
        JPanel addingPanel = new JPanel(new GridBagLayout());
        GridBagConstraints tc = new GridBagConstraints();
        addingPanel.setBackground(this.tapClient.primaryColor);
        tc.gridx = 0;
        tc.weightx = 0.01;
        tc.gridy = 0;
        c.anchor = 11;
        c.fill = 0;
        if (this.tapClient.mode == Constants.TapClientMode.DIALOG) {
            JButton button = this.tapClient.getChangeServerButton(this);
            addingPanel.add((Component)button, tc);
            ++tc.gridx;
        }
        if (this instanceof DynamicTapForm) {
            JButton reloadButton = TapClient.getReloadButton();
            reloadButton.addActionListener(this);
            addingPanel.add((Component)reloadButton, tc);
            ++tc.gridx;
        }
        JPanel titlePanel = new JPanel();
        titlePanel.setBackground(this.tapClient.primaryColor);
        titlePanel.setAlignmentY(0.0f);
        this.makeTitle(titlePanel, this.tapClient.getVisibleLabel());
        tc.weightx = 0.88;
        c.fill = 2;
        addingPanel.add((Component)titlePanel, tc);
        ++tc.gridx;
        JPanel optionsPanel = this.tapClient.getModes(this);
        if (optionsPanel != null) {
            optionsPanel.setBackground(this.tapClient.primaryColor);
            tc.weightx = 0.1;
            c.fill = 0;
            addingPanel.add((Component)optionsPanel, tc);
        }
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 11;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 1;
        containerPanel.add((Component)addingPanel, c);
        info1.setText(clientInstrucMessage);
        c.anchor = 11;
        c.fill = 0;
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 0.02;
        info1.setHorizontalAlignment(0);
        containerPanel.add((Component)info1, c);
        ++c.gridy;
    }

    public static JPanel getTablesPanel(TapClient tapClient, final FilterActionClass actionClass, String labelText, final JComboBox tablesGui, TapTable chosenTable, List<String> keys, List<JComponent> smallPrefixComponents, boolean isFirstTable) throws BadLocationException {
        JPanel tablesPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        tablesPanel.setLayout(gridbag);
        tablesPanel.setFont(CDSConstants.BOLD);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.insets = new Insets(1, 3, 1, 3);
        c.anchor = 17;
        c.fill = 17;
        c.weightx = 0.05;
        if (smallPrefixComponents != null && !smallPrefixComponents.isEmpty()) {
            for (JComponent smallPrefixComponent : smallPrefixComponents) {
                tablesPanel.add((Component)smallPrefixComponent, c);
                ++c.gridx;
            }
        }
        JLabel label = new JLabel();
        label.setName("TABLESLABEL");
        if (labelText == null) {
            labelText = "Table:";
        }
        label.setText(labelText);
        label.setFont(CDSConstants.BOLD);
        tablesPanel.add((Component)label, c);
        String tableToolTip = null;
        String selectedName = null;
        if (chosenTable != null) {
            tableToolTip = chosenTable.getDescription();
            selectedName = chosenTable.getTable_name();
        }
        if (tableToolTip != null && !tableToolTip.isEmpty()) {
            tablesGui.setToolTipText("<html><p width=\"500\">" + tableToolTip + "</p></html>");
        }
        if (keys != null && !keys.isEmpty()) {
            tablesGui.setEditable(true);
            JTextComponent tablesGuiEditor = (JTextComponent)tablesGui.getEditor().getEditorComponent();
            FilterDocument document = new FilterDocument(actionClass, tablesGui, keys, selectedName);
            tablesGuiEditor.setDocument(document);
        } else {
            tablesGui.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    actionClass.checkSelectionChanged(tablesGui);
                }
            });
        }
        tablesGui.setOpaque(false);
        tablesGui.setName("table");
        tablesGui.setAlignmentY(0.0f);
        c.insets = new Insets(1, 0, 1, 0);
        c.fill = 2;
        c.anchor = 10;
        ++c.gridx;
        c.weightx = 0.75;
        tablesPanel.add((Component)tablesGui, c);
        DynamicTapForm server = null;
        boolean isJoin = false;
        if (actionClass instanceof DynamicTapForm) {
            server = (DynamicTapForm)actionClass;
        } else if (actionClass instanceof JoinFacade) {
            server = ((JoinFacade)actionClass).serverTap;
            isJoin = true;
        }
        if (!isJoin && server instanceof ServerTap) {
            JButton button = new JButton("Set ra, dec");
            button.setName("RADECBUTTON");
            button.setActionCommand("OPEN_SET_RADEC");
            button.addActionListener(server);
            button.setToolTipText(SETRADECBUTTONTIP);
            c.insets = new Insets(1, 3, 1, 3);
            c.weightx = 0.1;
            ++c.gridx;
            tablesPanel.add((Component)button, c);
            button = new JButton("Join");
            c.weightx = 0.05;
            ++c.gridx;
            button.setActionCommand("JOIN_TABLE");
            tablesPanel.add((Component)button, c);
            button.addActionListener(server);
            button.setToolTipText(TAPTABLEJOINTIP);
        } else if (isJoin || server instanceof ServerTapExamples) {
            c.insets = new Insets(1, 3, 1, 3);
            c.weightx = 0.1;
            ++c.gridx;
            if (isFirstTable) {
                if (!isJoin) {
                    JToggleButton grab = server.getGrab();
                    grab.setToolTipText(CHANGETARGETSETTINGSTOOLTIP);
                    tablesPanel.add((Component)grab, c);
                }
            } else {
                tablesPanel.add((Component)server.getUploadButtonIfAvailable(null, tablesGui), c);
            }
        }
        return tablesPanel;
    }

    public JToggleButton getGrab() {
        this.target = new JTextField(40);
        Image image = Aladin.aladin.getImagette("Grab.png");
        this.grab = image == null ? new JToggleButton("Grab") : new JToggleButton(new ImageIcon(image));
        JToggleButton b = this.grab;
        Util.toolTip(b, "Grab a position/radius in the view");
        b.setMargin(new Insets(0, 0, 0, 0));
        b.setBorderPainted(false);
        b.setContentAreaFilled(false);
        this.grab.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DynamicTapForm.this.aladin.f.toFront();
                DynamicTapForm server = DynamicTapForm.this;
                DynamicTapForm.this.aladin.grabUtilInstance.grabFrame = (GrabItFrame)((Object)SwingUtilities.getRoot(server));
            }
        });
        this.grab.setFont(Aladin.SBOLD);
        Component rootFrame = SwingUtilities.getRoot(this);
        if (rootFrame instanceof GrabItFrame) {
            this.updateWidgets((GrabItFrame)((Object)rootFrame));
        }
        this.radius = new JTextField(50);
        this.modeCoo = 32;
        this.modeRad = 512;
        if (this.coo == null) {
            this.coo = new JTextField[2];
            this.coo[0] = new JTextField();
            this.coo[1] = new JTextField();
        }
        if (this.rad == null) {
            this.rad = new JTextField[2];
            this.rad[0] = new JTextField();
            this.rad[1] = new JTextField();
        }
        return this.grab;
    }

    protected void createTargetPanel(JPanel targetPanel) {
        targetPanel.removeAll();
        GridBagLayout gridbag = new GridBagLayout();
        targetPanel.setLayout(gridbag);
        targetPanel.setFont(CDSConstants.BOLD);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.insets = new Insets(1, 1, 1, 1);
        c.fill = 1;
        c.weightx = 0.1;
        JLabel label = new JLabel("Target");
        label.setFont(CDSConstants.BOLD);
        gridbag.setConstraints(label, c);
        targetPanel.add(label);
        this.target = new JTextField(40);
        this.target.addKeyListener(this);
        this.target.addActionListener(this);
        c.gridx = 1;
        c.gridwidth = 2;
        c.weightx = 0.8;
        gridbag.setConstraints(this.target, c);
        targetPanel.add(this.target);
        JToggleButton b = this.grab = new JToggleButton(new ImageIcon(Aladin.aladin.getImagette("Grab.png")));
        Util.toolTip(b, "Grab a position/radius in the view");
        b.setMargin(new Insets(0, 0, 0, 0));
        b.setBorderPainted(false);
        b.setContentAreaFilled(false);
        this.grab.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DynamicTapForm.this.aladin.f.toFront();
                DynamicTapForm panel = DynamicTapForm.this;
                DynamicTapForm.this.aladin.grabUtilInstance.grabFrame = (GrabItFrame)((Object)SwingUtilities.getRoot(panel));
            }
        });
        this.grab.setFont(Aladin.SBOLD);
        Component rootFrame = SwingUtilities.getRoot(this);
        if (rootFrame instanceof GrabItFrame) {
            this.updateWidgets((GrabItFrame)((Object)rootFrame));
        }
        c.gridwidth = 1;
        c.weightx = 0.05;
        c.gridx = 3;
        gridbag.setConstraints(this.grab, c);
        targetPanel.add(this.grab);
        String radText = this.RAD;
        label = new JLabel(this.addDot(radText));
        label.setFont(Aladin.BOLD);
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.weightx = 0.1;
        gridbag.setConstraints(label, c);
        targetPanel.add(label);
        this.radius = new JTextField(50);
        this.radius.addKeyListener(this);
        this.radius.addActionListener(this);
        c.gridx = 1;
        c.weightx = 0.8;
        gridbag.setConstraints(this.radius, c);
        targetPanel.add(this.radius);
        this.circleOrSquare = new JComboBox<String>(Constants.CIRCLEORSQUARE);
        this.circleOrSquare.setOpaque(false);
        this.circleOrSquare.setName("posConstraintShape");
        this.circleOrSquare.setSelectedIndex(0);
        c.gridx = 2;
        c.weightx = 0.05;
        targetPanel.add(this.circleOrSquare, c);
        JButton button = new JButton("Add");
        button.setActionCommand("ADDPOSCONSTRAINT");
        button.addActionListener(this);
        button.setToolTipText(TIPCLICKTOADD);
        c.weightx = 0.05;
        c.gridx = 3;
        gridbag.setConstraints(button, c);
        targetPanel.add(button);
        Util.toolTip(label, this.RADIUS_EX);
        Util.toolTip(this.radius, this.RADIUS_EX);
        this.modeCoo = 32;
        this.modeRad = 512;
        if (this.coo == null) {
            this.coo = new JTextField[2];
            this.coo[0] = new JTextField();
            this.coo[1] = new JTextField();
        }
        if (this.rad == null) {
            this.rad = new JTextField[2];
            this.rad[0] = new JTextField();
            this.rad[1] = new JTextField();
        }
        targetPanel.setVisible(true);
    }

    public JPanel getBottomPanel(boolean isForLoaded) {
        JPanel bottomPanel = new JPanel(new FlowLayout(0));
        bottomPanel.setBackground(this.tapClient.primaryColor);
        JButton button = new JButton("Refresh query");
        if (isForLoaded && this instanceof ServerTap) {
            button.setToolTipText(REFRESHQUERYTOOLTIP);
            button.setActionCommand("WRITEQUERY");
            button.addActionListener(this);
            bottomPanel.add(button);
        }
        button = new JButton("Check..");
        button.setToolTipText(CHECKQUERYTOOLTIP);
        button.setActionCommand("CHECKQUERY");
        button.addActionListener(this);
        bottomPanel.add(button);
        this.sync_async = new JComboBox<String>(Constants.SYNC_ASYNC);
        this.sync_async.setOpaque(false);
        if (SYNCASYNCTOOLTIP != null && !SYNCASYNCTOOLTIP.isEmpty()) {
            this.sync_async.setToolTipText("<html><p width=\"500\">" + SYNCASYNCTOOLTIP + "</p></html>");
        }
        bottomPanel.add(this.sync_async);
        button = new JButton("Async jobs>>");
        button.setActionCommand("SHOWAYNCJOBS");
        button.setToolTipText(SHOWASYNCTOOLTIP);
        button.addActionListener(this);
        bottomPanel.add(button);
        return bottomPanel;
    }

    public JButton getUploadButtonIfAvailable(String label, JComboBox tablesGui) {
        JButton button;
        block10: {
            String defaultLanel = "Edit table name";
            String uploadTipText = TAPTABLEUPLOADTIP;
            button = null;
            if (label == null) {
                Image image = Aladin.aladin.getImagette("settings.png");
                if (image == null) {
                    button = new JButton(defaultLanel);
                } else {
                    button = new JButton(new ImageIcon(image));
                    button.setBorderPainted(false);
                    button.setMargin(new Insets(0, 0, 0, 0));
                    button.setContentAreaFilled(true);
                }
            } else {
                button = new JButton(label);
            }
            button.setActionCommand("EDITUPLOADTABLENAMEACTION");
            if (this.tapClient.capabilities != null) {
                try {
                    VOSICapabilitiesReader meta = this.tapClient.capabilities.get();
                    button.setEnabled(meta.isUploadAllowed());
                    final JButton editVutton = button;
                    tablesGui.addPropertyChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            if (evt.getPropertyName().equals("enabled")) {
                                if (((Boolean)evt.getNewValue()).booleanValue()) {
                                    editVutton.setEnabled(true);
                                } else {
                                    editVutton.setEnabled(false);
                                }
                                ((JComboBox)evt.getSource()).setToolTipText(NOSTACKTABLES);
                            }
                        }
                    });
                    button.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DynamicTapForm.this.tapClient.tapManager.uploadFacade.uploadSettingsClickAction((JButton)e.getSource());
                        }
                    });
                    if (meta.isUploadAllowed() && meta.getUploadHardLimit() > 0L) {
                        String tip = String.format(TAPTABLEUPLOADLIMITTOOLTIP, meta.getUploadHardLimit());
                        uploadTipText = uploadTipText.concat(tip);
                    } else if (!meta.isUploadAllowed()) {
                        uploadTipText = TAPTABLENOUPLOADTIP;
                    }
                    button.setToolTipText(uploadTipText);
                }
                catch (Exception e) {
                    if (Aladin.levelTrace < 3) break block10;
                    e.printStackTrace();
                }
            }
        }
        return button;
    }

    public abstract void changeTableSelection(String var1);

    @Override
    public void checkSelectionChanged(JComboBox<String> comboBox) {
        if (comboBox.getSelectedItem() != null && !this.selectedTableName.equalsIgnoreCase(comboBox.getSelectedItem().toString())) {
            Aladin.trace(3, "Change table selection from within the document");
            if (this instanceof ServerTap) {
                ((ServerTap)this).resetJoin();
            }
            if (comboBox == this.tablesGui) {
                this.selectedTableName = (String)comboBox.getSelectedItem();
                this.changeTableSelection(this.selectedTableName);
            }
        }
    }

    public Vector<TapTableColumn> setTableGetColumnsToLoad(String tableChoice, Map<String, TapTable> tablesMetaData) {
        this.selectedTableName = tableChoice == null || !tablesMetaData.keySet().contains(tableChoice) ? tablesMetaData.keySet().iterator().next() : tableChoice;
        String tableToolTip = tablesMetaData.get(this.selectedTableName).getDescription();
        if (tableToolTip != null && !tableToolTip.isEmpty()) {
            this.tablesGui.setToolTipText("<html><p width=\"500\">" + tableToolTip + "</p></html>");
        } else {
            this.tablesGui.setToolTipText(null);
        }
        Vector<TapTableColumn> columnNames = this.getColumnsToLoad(this.selectedTableName, tablesMetaData);
        return columnNames;
    }

    public Vector<TapTableColumn> getColumnsToLoad(String tableName, Map<String, TapTable> tablesMetaData) {
        Vector<TapTableColumn> columnNames = tablesMetaData.get(tableName).getColumns();
        if (columnNames == null) {
            try {
                ArrayList<String> tableNamesToUpdate = new ArrayList<String>();
                tableNamesToUpdate.add(tableName);
                this.tapClient.tapManager.updateTableColumnSchemas(this, tableNamesToUpdate);
                columnNames = tablesMetaData.get(tableName).getColumns();
                if (this instanceof ServerObsTap) {
                    ((ServerObsTap)this).setObsCore(this.tapClient.obscoreTables.get(tableName));
                }
            }
            catch (Exception e) {
                Aladin.error(this, e.getMessage());
                String revertTable = tablesMetaData.keySet().iterator().next();
                if (tablesMetaData.get(revertTable).getColumns() != null) {
                    JTextComponent tablesGuiEditor = (JTextComponent)this.tablesGui.getEditor().getEditorComponent();
                    FilterDocument tapTableFilterDocument = (FilterDocument)tablesGuiEditor.getDocument();
                    try {
                        tapTableFilterDocument.setDefault();
                        this.changeTableSelection(revertTable);
                    }
                    catch (BadLocationException e1) {
                        e1.printStackTrace();
                        this.showLoadingError();
                    }
                } else {
                    this.showLoadingError();
                }
                this.defaultCursor();
                return null;
            }
            if (columnNames == null) {
                Aladin.error(this, "Error in updating the metadata for :" + this.selectedTableName);
                this.showLoadingError();
                this.defaultCursor();
                return null;
            }
        }
        return columnNames;
    }

    @Override
    protected void showStatusReport() {
        this.showStatusReport(true);
    }

    protected void showStatusReport(boolean showTapInfoText) {
        block6: {
            if (this.aladin.frameInfoServer == null || !this.aladin.frameInfoServer.isOfDynamicTapServerType() || !this.aladin.frameInfoServer.isThisInfoPanel(this.tapClient)) {
                if (this.aladin.frameInfoServer != null) {
                    this.aladin.frameInfoServer.dispose();
                }
                this.aladin.frameInfoServer = this.tapClient.infoPanel != null ? new FrameInfoServer(this.aladin, this.tapClient.infoPanel) : new FrameInfoServer(this.aladin);
            }
            if (this.aladin.frameInfoServer.isFlagUpdate() == 1) {
                try {
                    this.aladin.frameInfoServer.updateInfoPanel();
                }
                catch (Exception e) {
                    if (Aladin.levelTrace < 3) break block6;
                    e.printStackTrace();
                }
            }
        }
        this.aladin.frameInfoServer.showHidetapInfoText(showTapInfoText);
        if (!this.aladin.frameInfoServer.isVisible()) {
            this.aladin.frameInfoServer.show(this);
        }
        this.aladin.frameInfoServer.toFront();
    }

    @Override
    public Vector<String> getMatches(String mask, JComboBox<String> comboBox) {
        Vector<String> matches = new Vector<String>();
        if (mask != null && !mask.isEmpty()) {
            for (String key : this.getTableNames()) {
                boolean checkDescription = false;
                TapTable table = this.tapClient.tablesMetaData.get(key);
                if (table != null && table.getDescription() != null && !table.getDescription().isEmpty()) {
                    checkDescription = true;
                }
                if (Util.indexOfIgnoreCase(key, mask) < 0 && (!checkDescription || Util.indexOfIgnoreCase(table.getDescription(), mask) < 0)) continue;
                matches.add(key);
            }
        }
        return matches;
    }

    @Override
    public ADQLQuery checkQuery(Map<String, Object> requestParams) throws UnresolvedIdentifiersException {
        ADQLQuery query = null;
        try {
            try {
                this.tapClient.updateUploadedTablesToADQLParser(this, requestParams);
            }
            catch (Exception e) {
                Aladin.trace(3, "error trying to update adql parser" + e.getMessage());
            }
            query = super.checkQuery(null);
        }
        catch (UnresolvedIdentifiersException uie) {
            Aladin.trace(3, "Number of errors in the query: " + uie.getNbErrors());
            ParseException ex = null;
            try {
                List<String> tableNames = this.getTableNamesofNoMetadataInQuery(this.tap.getText());
                if (tableNames != null && !tableNames.isEmpty()) {
                    try {
                        this.tapClient.tapManager.updateTableColumnSchemas(this, tableNames);
                        Aladin.trace(3, "updated metadata for these tables:" + uie.getNbErrors());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                } else {
                    throw uie;
                }
                query = this.adqlParser.parseQuery(this.tap.getText());
            }
            catch (UnresolvedIdentifiersException uie2) {
                Iterator<ParseException> it = uie2.getErrors();
                while (it.hasNext()) {
                    ex = it.next();
                    this.highlightQueryError(this.tap.getHighlighter(), ex);
                }
                this.tapClient.tapManager.eraseNotification(this.info1, MESSAGEUNKNOWNPARAMSINQUERY, this.CLIENTINSTR);
                throw uie2;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return query;
    }

    public List<String> getTableNamesofNoMetadataInQuery(String query) {
        ADQLParser syntaxParser = new ADQLParser();
        ArrayList<String> tableNames = null;
        try {
            ADQLQuery adqlQuery = syntaxParser.parseQuery(query);
            tableNames = new ArrayList<String>();
            for (ADQLTable adqlTable : adqlQuery.getFrom().getTables()) {
                String tableNameKey = this.getTableMetaCacheKey(adqlTable.getFullTableName());
                TapTable meta = this.tapClient.tablesMetaData.get(tableNameKey);
                Vector<TapTableColumn> columnNames = null;
                if (meta != null) {
                    columnNames = meta.getColumns();
                }
                if (columnNames != null) continue;
                tableNames.add(tableNameKey);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tableNames;
    }

    public String getTableMetaCacheKey(String fullTableName) {
        String result = fullTableName;
        if (fullTableName.contains("\"")) {
            result = fullTableName.replaceAll("\"", "");
        }
        return result;
    }

    public void updateQueryChecker(List<String> tableNames) {
        for (String tableName : tableNames) {
            this.updateQueryChecker(tableName);
        }
    }

    public void updateQueryChecker(String tableName) {
        this.updateQueryChecker(false, tableName, this.tapClient.tablesMetaData, this.tapClient.queryCheckerTables);
    }

    public void updateQueryChecker(boolean isUploadTable, String tableName, Map<String, TapTable> tablesMetaData, List<DefaultDBTable> queryCheckerTables) {
        DefaultDBTable table = new DefaultDBTable(tableName);
        DefaultDBTable queryCheckerTable = null;
        if (queryCheckerTables != null) {
            for (DefaultDBTable defaultDBTable : queryCheckerTables) {
                if (!TapManager.areSameQueryCheckerTables(defaultDBTable, table)) continue;
                queryCheckerTable = defaultDBTable;
                break;
            }
            if (tablesMetaData.containsKey(tableName)) {
                Vector<TapTableColumn> columns = tablesMetaData.get(tableName).getColumns();
                TapClient.updateQueryCheckTableColumns(table, columns);
                if (isUploadTable || queryCheckerTable != null && queryCheckerTables.remove(queryCheckerTable)) {
                    queryCheckerTables.add(table);
                    DBChecker checker = new DBChecker(queryCheckerTables);
                    this.adqlParser.setQueryChecker(checker);
                }
            }
        }
    }

    public void updateQueryChecker_deleteTable(String tableName, List<DefaultDBTable> queryCheckerTables) {
        DefaultDBTable table = new DefaultDBTable(tableName);
        DefaultDBTable queryCheckerTable = null;
        if (queryCheckerTables != null) {
            for (DefaultDBTable defaultDBTable : queryCheckerTables) {
                if (!TapManager.areSameQueryCheckerTables(defaultDBTable, table)) continue;
                queryCheckerTable = defaultDBTable;
                break;
            }
            if (queryCheckerTable != null && queryCheckerTables.remove(queryCheckerTable)) {
                DBChecker checker = new DBChecker(queryCheckerTables);
                this.adqlParser.setQueryChecker(checker);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        super.actionPerformed(arg0);
        Object source = arg0.getSource();
        if (source instanceof JButton) {
            String action = ((JButton)source).getActionCommand();
            if (action.equals("CHANGESERVER")) {
                try {
                    this.tapClient.tapManager.showTapRegistryForm();
                }
                catch (Exception e) {
                    Aladin.error(this, TapClient.GENERICERROR);
                    this.ball.setMode(3);
                }
            } else if (action.equals("SHOWAYNCJOBS")) {
                try {
                    UWSFacade.getInstance(this.aladin).showAsyncPanel();
                }
                catch (Exception e) {
                    Aladin.error(this, TapClient.GENERICERROR);
                    this.ball.setMode(3);
                }
            } else if (action.equals("RELOAD")) {
                try {
                    this.tapClient.reload(this);
                }
                catch (Exception e) {
                    if (Aladin.levelTrace >= 3) {
                        e.printStackTrace();
                    }
                    Aladin.error(this, e.getMessage());
                }
            }
        }
    }

    public Vector<String> getTableNames() {
        Vector<String> tables;
        block5: {
            block4: {
                tables = new Vector<String>();
                if (this.isFullServer || this.tapClient.nodeTableNames == null) break block4;
                for (String nodeTableName : this.tapClient.nodeTableNames) {
                    DefaultDBTable ntable = new DefaultDBTable(nodeTableName);
                    if (this.tapClient.tablesMetaData.containsKey(TapManager.getFullyQualifiedTableName(ntable))) {
                        tables.add(nodeTableName);
                        continue;
                    }
                    if (this.tapClient.tablesMetaData.containsKey(ntable.getADQLName())) {
                        tables.add(ntable.getADQLName());
                        continue;
                    }
                    String potentialTableName = nodeTableName.replaceFirst("^(?<prefix>(?<tableName>[\\p{L}_][\\p{L}\\p{N}@$#_]{0,127})?\\.)", "");
                    if (!this.tapClient.tablesMetaData.containsKey(potentialTableName)) continue;
                    tables.add(potentialTableName);
                }
                break block5;
            }
            tables.addAll(this.tapClient.tablesMetaData.keySet());
            if (!TapManager.getInstance((Aladin)this.aladin).hideTapSchema) break block5;
            ListIterator<String> tablesIterator = tables.listIterator(tables.size());
            int schemaTables = 5;
            while (tablesIterator.hasPrevious() && schemaTables > 0) {
                String tableName = tablesIterator.previous();
                if (!TapClient.isSchemaTable(tableName)) continue;
                tablesIterator.remove();
                --schemaTables;
            }
        }
        return tables;
    }

    public void showLoadingError() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.setBackground(this.tapClient.primaryColor);
        GridBagConstraints c = new GridBagConstraints();
        JPanel containerPanel = new JPanel(new GridBagLayout());
        this.CLIENTINSTR = "Error: unable to load " + this.tapClient.tapLabel;
        this.setTopPanel(containerPanel, c, this.info1, this.CLIENTINSTR);
        this.prepNoMetaDataScreen(containerPanel, c);
        this.ball.setMode(3);
        this.add(containerPanel);
        this.verboseDescr = TAPERRORSTATUSINFO;
        this.formLoadStatus = -1;
        this.revalidate();
        this.repaint();
    }

    public void showloading() {
        this.removeAll();
        this.formLoadStatus = 1;
        this.setLayout(new BorderLayout());
        this.setBackground(this.tapClient.primaryColor);
        GridBagConstraints c = new GridBagConstraints();
        JPanel containerPanel = new JPanel(new GridBagLayout());
        this.CLIENTINSTR = "loading " + this.tapClient.tapLabel + "...";
        this.setTopPanel(containerPanel, c, this.info1, this.CLIENTINSTR);
        this.prepNoMetaDataScreen(containerPanel, c);
        this.ball.setMode(4);
        this.add(containerPanel);
        this.verboseDescr = TAPLOADINGSTATUSINFO;
        this.revalidate();
        this.repaint();
    }

    public void prepNoMetaDataScreen(JPanel containerPanel, GridBagConstraints c) {
        JPanel linePanel = this.getBottomPanel(false);
        c.gridwidth = 1;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 0.02;
        c.insets = new Insets(0, -6, 0, 0);
        c.fill = 0;
        ++c.gridy;
        containerPanel.add((Component)linePanel, c);
        this.tap = new JTextArea(8, 100);
        this.tap.setFont(Aladin.ITALIC);
        this.tap.setWrapStyleWord(true);
        this.tap.setLineWrap(true);
        this.tap.setEditable(true);
        JScrollPane scrolley = new JScrollPane(this.tap);
        c.weighty = 0.75;
        c.weightx = 1.0;
        c.insets = new Insets(0, 4, 0, 0);
        c.fill = 1;
        ++c.gridy;
        containerPanel.add((Component)scrolley, c);
    }

    public boolean isNotLoaded() {
        return this.formLoadStatus == 0;
    }

    public boolean isLoaded() {
        return this.formLoadStatus == 2;
    }

    static {
        TIPRETRY = Aladin.chaine.getString("TAPTIPRETRY");
        TAPTABLEJOINTIP = Aladin.chaine.getString("TAPTABLEJOINTIP");
        DISCARD = Aladin.chaine.getString("DISCARD");
        DISCARDTIP = Aladin.chaine.getString("DISCARDTIP");
        SETRADECBUTTONTIP = Aladin.chaine.getString("SETRADECBUTTONTIP");
        CHANGETARGETSETTINGSTOOLTIP = Aladin.chaine.getString("TAPTARGETSETTINGSTOOLTIP");
        TIPCLICKTOADD = Aladin.chaine.getString("TIPCLICKTOADD");
        TAPEXDEFAULTMAXROWS = ConfigurationReader.getInstance().getPropertyValue("TAPEXDEFAULTMAXROWS");
        TAPERRORSTATUSINFO = Aladin.chaine.getString("TAPERRORSTATUSINFO");
        TAPLOADINGSTATUSINFO = Aladin.chaine.getString("TAPLOADINGSTATUSINFO");
        MESSAGEUNKNOWNPARAMSINQUERY = Aladin.chaine.getString("MESSAGEUNKNOWNPARAMSINQUERY");
        TAPTABLEUPLOADLIMITTOOLTIP = Aladin.chaine.getString("TAPTABLEUPLOADLIMITTOOLTIP");
        NOSTACKTABLES = Aladin.chaine.getString("NOSTACKTABLES");
    }
}

